/*************************************************************************
Driver Library Interface Header Definitions

  Company:
    Microchip Technology Inc.
	
  File Name:
    drv.h
	
  Summary:
    This file aggregates all of the driver library interface headers.
	
  Description:
    Driver Library Interface Header
    This file aggregates all of the driver library interface headers so
    client code only needs to include this one single header to obtain
    prototypes and definitions for the interfaces to all driver libraries.
    A device driver provides a simple well-defined interface to a hardware
    peripheral that can be used without operating system support or that
    can be easily ported to a variety of operating systems.
    A driver has the fundamental responsibilities:
      * Providing a highly abstracted interface to a peripheral
      * Controlling access to a peripheral
      * Managing the state of a peripheral
	  
  Remarks:
    The directory in which this file resides should be added to the
    compiler's search path for header files.                              
  *************************************************************************/
 
//DOM-IGNORE-BEGIN
/*******************************************************************************
Copyright (c) 2010-2013 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
 *******************************************************************************/
//DOM-IGNORE-END

#ifndef _DRIVER_H
#define _DRIVER_H


// *****************************************************************************
// *****************************************************************************
// Section: Included Driver Module Headers Files
// *****************************************************************************
// *****************************************************************************

#include "driver/driver_common.h"


#endif // _DRIVER_H
/*******************************************************************************
 End of File
*/

